import ApiPath from "@/network/api/apiPath";

export const loadLanguages = async () => {
  try {
    const res = await fetch(ApiPath.baseURL + ApiPath.languages, {
      next: { revalidate: 60 }, // Revalidate every 60 seconds
    });
    const data = await res.json();
    return data.data || [];
  } catch (err) {
    console.error("Language load error:", err);
    return [];
  }
};

export const getDefaultLanguage = (languages) => {
  return languages.find((lang) => lang.is_default) || languages[0];
};

export const getSelectedLanguage = (languages, locale) => {
  return languages.find((lang) => lang.locale === locale) || languages[0];
};
